// Scilab ( http://www.scilab.org/ ) - This file is part of Scilab
// Copyright (C) INRIA
// Copyright (C) 2012 - Scilab Enterprises - Adeline CARNIS
// 
// This file must be used under the terms of the CeCILL.
// This source file is licensed as described in the file COPYING, which
// you should have received as part of this distribution.  The terms
// are also available at    
// http://www.cecill.info/licences/Licence_CeCILL_V2-en.txt

function [x,k] = %hm_max(varargin)
    n = size(varargin)
    // One input argument
    if n == 1 then
        // Retrieve the dimensions
        m = varargin(1).dims
        // Compute the max of column vector
        // varargin(1).entries gives column vector
        [x,k] = max(varargin(1).entries)
        // check if lhs = 2 and if varargin(1) is vector
        if (argn(1) > 1 & (m(length(m)) <> size(varargin(1), "*"))) then
            k = ind2sub(m, k(1))
        end
    else
        if n==2 then
            d=varargin(2)
            // Check if d is a string
            if type(d)==10 then
                [x,k]=%hm_oriented_max(varargin(1),d)
                return
            end
        end
        // if the second input argument is a matrix or hypermatrix
        // Obtain column vector
        x=varargin(1)(:)
        dims=size(varargin(1))
        for kk=2:n
            sz=size(varargin(kk))
            // check if the dim are different
            if or(dims<>sz) then 
                if prod(dims)<>1&prod(sz)<>1 then
                    error(42)
                end
                // the first argument is a scalar
                if prod(dims)==1 then dims=sz,end
            end
            // max between hypermatrix and hypermatrix
            [x,k]=max(x,varargin(kk)(:))
        end
        x=hypermat(dims,x)
        k=hypermat(dims,k)
    end
endfunction

function [x,k]=%hm_oriented_max(m,d)
    if d=='m' then
        d=find(m.dims>1,1)
        if d==[] then 
            [x,k1]=max(m.entries)
            k=ind2sub(m.dims,k1(1))
            return,
        end
    elseif d=='r' then 
        d=1
    elseif d=='c' then
        d=2
    end
    dims=m.dims;
    if type(dims==8) then flag=1; dims=double(dims); else flag=0;end
    N=size(dims,'*');
    p1=prod(dims(1:d-1));// step for one max
    p2=p1*dims(d);//step for beginning of vector to max 
    ind=(0:p1:p2-1)';// selection for vector to max
    deb=(1:p1);
    I=ind*ones(deb)+ones(ind)*deb 

    ind=(0:p2:prod(dims)-1);
    I=ones(ind).*.I+ind.*.ones(I)

    [x,k]=max(matrix(m.entries(I),dims(d),-1),'r')

    dims(d)=1
    if d==N then
        dims=dims(1:$)
    else
        dims(d)=1
    end
    if size(dims,'*')==2 then 
        if flag==1 then dims=int32(dims);end
        x=matrix(x,dims(1),dims(2))
        k=matrix(k,dims(1),dims(2))
    else
        if flag==1 then dims=int32(dims);end
        x=hypermat(dims,matrix(x,-1,1))
        k=hypermat(dims,matrix(k,-1,1))
    end
endfunction










